/* ============ */
/* srcrdefs.h	*/
/* ============ */
/* ==================================================================== */
/*     TYPEDEFS, #DEFINES AND PROTOTYPES FOR SERIAL CORRELATION TEST 	*/
/* ==================================================================== */
# if defined(__SRCRDEFS_H__)
#	/* Do Nothing */
# else
#	define	__SRCRDEFS_H__

# if !defined(__DEFCODES)

typedef	unsigned char		UCHAR;
typedef	unsigned int		UINT;
typedef	unsigned long		ULONG;

# if !defined(DEBUG)
#	define	P( F )
# else
#	define	P( F )	F
# endif

#define	SQR(x)	((x) * (x))

#define	OK		 0
#define	ERROR_MIN_COEFS	-1
#define	ERROR_MIN_OBS	-2
#define	ERROR_NUM_COEFS	-3
#define	ERROR_SOS	-4

# endif

#define	MAX_COEFS(N)	((N >= MIN_VARIATES) ? (N-3) : 0)
#define	MIN_COEFS	1
#define	MAX_VARIATES	4000
#define	MIN_VARIATES	4
#define	MAX_CHI_SQ	1000
#define	MIN_CHI_SQ	20

/* ------------------- */
/* FUNCTION PROTOTYPES */
/* ------------------- */
# undef F
# if defined(__STDC__) || defined(__PROTO__)
#	define  F( P )  P
# else
#	define  F( P )  ()
# endif

/* INDENT OFF */
typedef	struct	SerCorDataStru
    {
	UINT	NumVarPerPass;          /* No. Variates per Pass	*/
	UINT	NumCoefs;		/* No. Coefs Per Chi-Square	*/
	double	NumOutliers;            /* No. Coefs Too Large		*/
	double	TotCoefs;		/* Total No. Coefs Generated	*/
	double	TotSos;			/* Accumulated Sum of Squares	*/
	double	TotSum;			/* Accumulated Sum of Coefs	*/
	double	ChiSqProb;		/* Chi-square P-Value		*/
	int	CallStatus;		/* 0 = OK, -1 = ERROR		*/
	int	(*RandFun) F((void));	/* Addr. of Generating Function	*/
    }
	SERCOR_DATA_STRU;

extern	int	BJCoef F((int *, int, double *, int));
extern	void	CalcSerCorChiSq F((struct SerCorDataStru *));
extern	void	SetSerialCorrelationControls F((SERCOR_DATA_STRU *));

# undef F
/* INDENT ON */

# endif				/* <<< __SRCRDEFS_H__ >>> */

